// ===============================================
// activity-format.js
// Transformă un timestamp într-un text prietenos:
// - "Acum X minute"
// - "Ieri"
// - "Acum 3 zile"
// - "Acum mult timp"
// ===============================================

window.ActivityFormat = {
    formatShort(dateString) {
        if (!dateString) return "Nicio activitate";

        const past = new Date(dateString);
        const now = new Date();
        const diffMs = now - past;

        if (isNaN(diffMs)) return "Nicio activitate";

        const diffMinutes = Math.floor(diffMs / 60000);
        const diffHours = Math.floor(diffMinutes / 60);
        const diffDays = Math.floor(diffHours / 24);

        if (diffMinutes < 1) return "Acum câteva secunde";
        if (diffMinutes < 60) return `Acum ${diffMinutes} minute`;
        if (diffHours < 24)   return `Acum ${diffHours} ore`;
        if (diffDays === 1)   return "Ieri";
        if (diffDays <= 7)    return `Acum ${diffDays} zile`;
        if (diffDays <= 30)   return "Acum câteva săptămâni";

        return "Acum mult timp";
    }
};
