// ===============================================
// api.js
// Strat unic pentru request-uri HTTP.
// Când vei trece pe Python, schimbi aici baza de URL
// și toată aplicația va continua să funcționeze la fel.
// ===============================================

const API_CONFIG = {
    BASE_URL: "https://crm.sviaen.com/api/", // schimbă pe viitor pe Python
    API_KEY: "sviaen-api-crm"                // dacă vei folosi cheie
};

window.API = {
    async request(endpoint, options = {}) {
        const url = API_CONFIG.BASE_URL + endpoint;

        const headers = options.headers || {};
        headers["Content-Type"] = "application/json";
        headers["X-API-KEY"] = API_CONFIG.API_KEY;

        const token = Auth.getToken();
        if (token) {
            headers["Authorization"] = `Bearer ${token}`;
        }

        const response = await fetch(url, {
            method: options.method || "GET",
            headers,
            body: options.body ? JSON.stringify(options.body) : undefined
        });

        if (!response.ok) {
            const msg = await response.text();
            throw new Error(`Eroare API: ${response.status} - ${msg}`);
        }

        return response.json();
    },

    get(endpoint) {
        return this.request(endpoint, { method: "GET" });
    },
    post(endpoint, body) {
        return this.request(endpoint, { method: "POST", body });
    },
    put(endpoint, body) {
        return this.request(endpoint, { method: "PUT", body });
    },
    del(endpoint) {
        return this.request(endpoint, { method: "DELETE" });
    }
};
