// ===============================================
// leads.js
// Tot ce ține de:
// - încărcare leaduri
// - afișare leaduri în tabel
// - filtru/căutare (pe viitor)
// - deschidere panou detalii
// ===============================================

window.Leads = {
    data: [],

    async initPage() {
        // Aici poți lega event-uri specifice paginii de leaduri
        await this.loadLeads();
        this.renderTable();
        this.bindEvents();
    },

    async loadLeads() {
        try {
            const resp = await API.get("get_leads.php"); // adaptezi la Python mai târziu
            this.data = resp.leads || [];
        } catch (e) {
            console.error("Eroare la încărcarea leadurilor:", e);
            this.data = [];
        }
    },

    renderTable() {
        const tbody = document.querySelector("#leadsTableBody");
        if (!tbody) return;
        tbody.innerHTML = "";

        this.data.forEach(lead => {
            const tr = document.createElement("tr");
            tr.dataset.leadId = lead.id;

            tr.innerHTML = `
                <td>${lead.id}</td>
                <td>${lead.name || "-"}</td>
                <td>${lead.email || "-"}</td>
                <td>
                    <span class="${this.getStatusClass(lead.status)}">
                        ${this.getStatusLabel(lead.status)}
                    </span>
                </td>
                <td>${ActivityFormat.formatShort(lead.last_activity)}</td>
            `;

            tbody.appendChild(tr);
        });
    },

    bindEvents() {
        const tbody = document.querySelector("#leadsTableBody");
        if (!tbody) return;

        tbody.addEventListener("click", (e) => {
            const tr = e.target.closest("tr");
            if (!tr) return;

            const id = tr.dataset.leadId;
            const lead = this.data.find(l => String(l.id) === String(id));
            if (!lead) return;

            Panel.open("lead", lead);
        });
    },

    getStatusConfig(status) {
        return StatusConfig.lead[status] || StatusConfig.lead.nou;
    },

    getStatusClass(status) {
        return this.getStatusConfig(status).className;
    },

    getStatusLabel(status) {
        return this.getStatusConfig(status).label;
    }
};
