// ===============================================
// router.js
// Se ocupă de:
// - ascultat click pe itemele din sidebar
// - încărcat pagina corectă în #app-content
// - apelat funcția de inițializare a fiecărei pagini
// ===============================================

window.Router = {
    currentPage: null,
    routes: {
        dashboard: { path: "pages/dashboard.html", init: null },
        leads:     { path: "pages/leads.html",     init: Leads.initPage },
        clients:   { path: "pages/clients.html",   init: Clients.initPage },
        tasks:     { path: "pages/tasks.html",     init: Tasks.initPage },
        settings:  { path: "pages/settings.html",  init: null }
    },

    init() {
        this.bindSidebarNavigation();
    },

    bindSidebarNavigation() {
        const sidebar = document.getElementById("app-sidebar");
        if (!sidebar) return;

        sidebar.addEventListener("click", (e) => {
            const item = e.target.closest(".sidebar-item");
            if (!item) return;

            const page = item.getAttribute("data-page");
            if (!page) return;

            this.navigate(page);
        });
    },

    async navigate(pageName) {
        const route = this.routes[pageName];
        if (!route) return;

        this.currentPage = pageName;

        // 1. Actualizăm starea vizuală în sidebar
        this.highlightSidebar(pageName);

        // 2. Încărcăm HTML-ul paginii
        const container = document.getElementById("app-content");
        const html = await fetch(route.path).then(r => r.text());
        container.innerHTML = html;

        // 3. Apelăm funcția de inițializare, dacă există
        if (typeof route.init === "function") {
            route.init();
        }
    },

    highlightSidebar(pageName) {
        const items = document.querySelectorAll(".sidebar-item");
        items.forEach(i => {
            const page = i.getAttribute("data-page");
            i.classList.toggle("active", page === pageName);
        });
    }
};
