// ===============================================
// ui.js
// Lucruri de interfață pură:
// - tema (dark / light)
// - eventual: loader, toast, etc.
// ===============================================

window.UI = {
    initTheme() {
        const saved = localStorage.getItem("sviaen_theme");
        if (saved === "light") {
            document.documentElement.setAttribute("data-theme", "light");
        } else {
            document.documentElement.removeAttribute("data-theme");
        }
    },

    toggleTheme() {
        const isLight = document.documentElement.getAttribute("data-theme") === "light";
        if (isLight) {
            document.documentElement.removeAttribute("data-theme");
            localStorage.setItem("sviaen_theme", "dark");
        } else {
            document.documentElement.setAttribute("data-theme", "light");
            localStorage.setItem("sviaen_theme", "light");
        }
    }
};
